/*
 * Decompiled with CFR 0.152.
 */
package co.nstant.in.cbor.encoder;

import co.nstant.in.cbor.CborEncoder;
import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.model.AdditionalInformation;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.MajorType;
import co.nstant.in.cbor.model.Tag;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;

public abstract class AbstractEncoder<T> {
    private final OutputStream outputStream;
    protected final CborEncoder encoder;

    public AbstractEncoder(CborEncoder encoder, OutputStream outputStream) {
        this.encoder = encoder;
        this.outputStream = outputStream;
    }

    public abstract void encode(T var1) throws CborException;

    protected void encodeTypeChunked(MajorType majorType) throws CborException {
        int symbol = majorType.getValue() << 5;
        symbol |= AdditionalInformation.INDEFINITE.getValue();
        try {
            this.outputStream.write(symbol);
        }
        catch (IOException ioException) {
            throw new CborException(ioException);
        }
    }

    protected void encodeTypeAndLength(MajorType majorType, long length) throws CborException {
        int symbol = majorType.getValue() << 5;
        if (length <= 23L) {
            this.write((int)((byte)((long)symbol | length)));
        } else if (length <= 255L) {
            this.write((byte)(symbol |= AdditionalInformation.ONE_BYTE.getValue()), (byte)length);
        } else if (length <= 65535L) {
            this.write((byte)(symbol |= AdditionalInformation.TWO_BYTES.getValue()), (byte)(length >> 8), (byte)(length & 0xFFL));
        } else if (length <= 0xFFFFFFFFL) {
            this.write((byte)(symbol |= AdditionalInformation.FOUR_BYTES.getValue()), (byte)(length >> 24 & 0xFFL), (byte)(length >> 16 & 0xFFL), (byte)(length >> 8 & 0xFFL), (byte)(length & 0xFFL));
        } else {
            this.write((byte)(symbol |= AdditionalInformation.EIGHT_BYTES.getValue()), (byte)(length >> 56 & 0xFFL), (byte)(length >> 48 & 0xFFL), (byte)(length >> 40 & 0xFFL), (byte)(length >> 32 & 0xFFL), (byte)(length >> 24 & 0xFFL), (byte)(length >> 16 & 0xFFL), (byte)(length >> 8 & 0xFFL), (byte)(length & 0xFFL));
        }
    }

    protected void encodeTypeAndLength(MajorType majorType, BigInteger length) throws CborException {
        boolean negative = majorType == MajorType.NEGATIVE_INTEGER;
        int symbol = majorType.getValue() << 5;
        if (length.compareTo(BigInteger.valueOf(24L)) < 0) {
            this.write(symbol | length.intValue());
        } else if (length.compareTo(BigInteger.valueOf(256L)) < 0) {
            this.write((byte)(symbol |= AdditionalInformation.ONE_BYTE.getValue()), (byte)length.intValue());
        } else if (length.compareTo(BigInteger.valueOf(65536L)) < 0) {
            long twoByteValue = length.longValue();
            this.write((byte)(symbol |= AdditionalInformation.TWO_BYTES.getValue()), (byte)(twoByteValue >> 8), (byte)(twoByteValue & 0xFFL));
        } else if (length.compareTo(BigInteger.valueOf(0x100000000L)) < 0) {
            long fourByteValue = length.longValue();
            this.write((byte)(symbol |= AdditionalInformation.FOUR_BYTES.getValue()), (byte)(fourByteValue >> 24 & 0xFFL), (byte)(fourByteValue >> 16 & 0xFFL), (byte)(fourByteValue >> 8 & 0xFFL), (byte)(fourByteValue & 0xFFL));
        } else if (length.compareTo(new BigInteger("18446744073709551616")) < 0) {
            BigInteger mask = BigInteger.valueOf(255L);
            this.write((byte)(symbol |= AdditionalInformation.EIGHT_BYTES.getValue()), length.shiftRight(56).and(mask).byteValue(), length.shiftRight(48).and(mask).byteValue(), length.shiftRight(40).and(mask).byteValue(), length.shiftRight(32).and(mask).byteValue(), length.shiftRight(24).and(mask).byteValue(), length.shiftRight(16).and(mask).byteValue(), length.shiftRight(8).and(mask).byteValue(), length.and(mask).byteValue());
        } else {
            if (negative) {
                this.encoder.encode(new Tag(3L));
            } else {
                this.encoder.encode(new Tag(2L));
            }
            this.encoder.encode(new ByteString(length.toByteArray()));
        }
    }

    protected void write(int b) throws CborException {
        try {
            this.outputStream.write(b);
        }
        catch (IOException ioException) {
            throw new CborException(ioException);
        }
    }

    protected void write(byte ... bytes) throws CborException {
        try {
            this.outputStream.write(bytes);
        }
        catch (IOException ioException) {
            throw new CborException(ioException);
        }
    }
}

