# This is the Cython setup file

from setuptools import setup
from Cython.Build import cythonize
import Cython.Compiler.Options
import os, shutil
os.chdir(os.path.dirname(os.path.abspath(__file__)))

PLUGIN_NAME = "Diffusae"

python_sources = [
    "scheduling_ddim.py"
]

cython_sources = [
    
]

# add BSKL folder
for root, dirs, files in os.walk("bskl"):
    for file in files:
        if file.endswith(".py") and file != "__init__.py":
            python_sources.append("BSKL/" + file)

# copy all .py files to .pyx files
for file in python_sources:
    shutil.copy(file, file.replace(".py", ".pyx"))

# create list of .pyx files for cython
print("Will cytonize the following files:")
for file in python_sources:
    file_pyx = file.replace(".py", ".pyx")
    cython_sources.append(file_pyx)
    print(file_pyx)

# build with cython
setup(
    name=PLUGIN_NAME,
    ext_modules=cythonize(cython_sources, language_level = "3"),
    zip_safe=False,
)

# delete all .pyx files
for file in cython_sources:
    os.remove(file)


print("Done!")